const stores = [
    { name: 'Зоорай', address: 'ул. Тимофея Кармацкого, 20, ТЦ "Алебашевский Bazar"', lat: 57.1522, lng: 65.5272 },
    { name: 'Зоорай', address: 'ул. Дмитрия Менделеева, 1, ТЦ АТАН', lat: 57.1530, lng: 65.5280 },
    { name: 'Зоорай', address: 'Московский тракт, 120 стр. 9', lat: 57.1515, lng: 65.5265 },
    { name: 'Зоорай', address: 'ул. Геологоразведчиков, 24', lat: 57.1540, lng: 65.5290 },
    { name: 'Зоорай', address: 'ул. Дмитрия Менделеева, 18, ТРЦ "Дарина"', lat: 57.1525, lng: 65.5275 },
    { name: 'Зоорай', address: 'ул. Алебашевская, 19, ТЦ "Зеленый Берег"', lat: 57.1510, lng: 65.5260 },
    { name: 'Зоорай', address: 'Московский тракт, 118, ТРЦ "Колумб"', lat: 57.1505, lng: 65.5255 },
    { name: 'Зоорай', address: 'ул. Александра Протозанова, 4', lat: 57.1535, lng: 65.5285 },
    { name: 'Зоорай', address: 'ул. Анатолия Клиндюка, 2 к1', lat: 57.1528, lng: 65.5278 },
    { name: 'Зоорай', address: 'ул. Западносибирская, 22/8', lat: 57.1518, lng: 65.5268 },
    { name: 'Зоорай', address: 'ул. Тимофея Чаркова, 83', lat: 57.1545, lng: 65.5295 },
    { name: 'Зоорай', address: 'ул. Федюнинского, 60', lat: 57.1500, lng: 65.5250 },
    { name: 'Зоорай', address: 'ул. Лесопарковая, 1 к2', lat: 57.1550, lng: 65.5300 },
    { name: 'Зоорай', address: 'ул. Федюнинского, 67, ТЦ "Остров"', lat: 57.1495, lng: 65.5245 },
    { name: 'Зоорай', address: 'ул. Мельникайте, 126 к2, ТЦ "П.О.Р.Т."', lat: 57.1548, lng: 65.5298 },
    { name: 'Зоорай', address: 'ул. Республики, 204 кор. 6', lat: 57.1523, lng: 65.5273 },
    { name: 'Зоорай', address: 'ул. Николая Ростовцева, 24', lat: 57.1513, lng: 65.5263 },
    { name: 'Зоорай', address: 'ул. Пермякова, 50Б, ТРЦ "Солнечный"', lat: 57.1533, lng: 65.5283 },
    { name: 'Зоорай', address: 'ул. Ямская, 118, ТЦ "Ямской"', lat: 57.1508, lng: 65.5258 }
];

document.addEventListener('DOMContentLoaded', function() {
    if (document.getElementById('map')) {
        const map = L.map('map').setView([57.1522, 65.5272], 12);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors',
            maxZoom: 19
        }).addTo(map);

        const storesList = document.getElementById('stores-list');
        if (storesList) {
            stores.forEach((store, index) => {
                const storeItem = document.createElement('div');
                storeItem.className = 'store-item';
                storeItem.innerHTML = `
                    <div class="store-item-content">
                        <h4>${store.name}</h4>
                        <p>${store.address}</p>
                    </div>
                `;
                storeItem.addEventListener('click', function() {
                    map.setView([store.lat, store.lng], 15);
                    highlightStore(index);
                });
                storesList.appendChild(storeItem);
            });
        }

        function highlightStore(index) {
            const items = document.querySelectorAll('.store-item');
            items.forEach((item, i) => {
                if (i === index) {
                    item.classList.add('active');
                } else {
                    item.classList.remove('active');
                }
            });
        }
    }
});

